<?php $__env->startSection('content'); ?>
<div class="content">
    <!-- BEGIN LOGIN FORM -->
    <form class="login-form" method="post" action="<?php echo e(route('login')); ?>">
        <?php echo e(csrf_field()); ?>

        <h3 class="form-title">Login to your account</h3>
        <div class="alert alert-danger display-hide">
            <button class="close" data-close="alert"></button>
            <span> Enter any username and password. </span>
        </div>
        <div class="form-group <?php echo e($errors->has('email') ? ' has-error' : ''); ?>">
            <!--ie8, ie9 does not support html5 placeholder, so we just show field title for that-->
            <label class="control-label visible-ie8 visible-ie9">Username</label>
            <div class="input-icon">
                <i class="fa fa-user"></i> 
                <input id="email" class="form-control placeholder-no-fix" type="email" placeholder="Email" name="email" autocomplete="off" value="<?php echo e(old('email')); ?>" required autofocus/>
                    <?php if($errors->has('email')): ?>
                        <span class="help-block">
                            <strong><?php echo e($errors->first('email')); ?></strong>
                        </span>
                    <?php endif; ?>
            </div>
        </div>
        <div class="form-group <?php echo e($errors->has('password') ? ' has-error' : ''); ?>">
            <label class="control-label visible-ie8 visible-ie9">Password</label>
            <div class="input-icon">
                <i class="fa fa-lock"></i>
                <input id="password" type="password" class="form-control placeholder-no-fix" placeholder="Password" name="password" required>
                <?php if($errors->has('password')): ?>
                    <span class="help-block">
                        <strong><?php echo e($errors->first('password')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>
        </div>
        <div class="form-actions">
            <label class="rememberme mt-checkbox mt-checkbox-outline">
                <input type="checkbox" name="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>> Remember Me
                <span></span>
            </label>
            <button type="submit" class="btn green pull-right"> Login </button>
        </div>
        <div class="forget-password">
            <h4>Forgot your password ?</h4>
            <p> no worries, click
            <a class="m-link" id="m_login_forget_password" href="<?php echo e(route('password.request')); ?>">
                Here
            </a> to reset your password. </p>
        </div>
    </form>
    <!-- END LOGIN FORM -->
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.login', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>