<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*Route::get('/', function () {
    return view('welcome');
});*/
Route::group(array('middleware' => 'forceSSL'), function() {
Auth::routes();

/*App Controller*/
Route::get('/', 'AppController@index')->name('App');
Route::get('/home', 'AppController@index')->name('App');
Route::get('/pdf/{id}', 'AppController@generatePdfv')->name('generatePdf');

/*Api*/
Route::get('api/get-auth-user','Api\UserController@getAuthUser');
Route::apiResource('api/workers', 'Api\WorkersController');
Route::apiResource('api/clients', 'Api\ClientsController');
Route::apiResource('api/providers', 'Api\ProvidersController');
Route::apiResource('api/parts', 'Api\PartsController');
Route::apiResource('api/provider-bills', 'Api\ProviderBillsController');
Route::apiResource('api/invoices', 'Api\InvoicesController');
Route::apiResource('api/estimates', 'Api\EstimatesController');
Route::apiResource('api/rent', 'Api\RentController');
Route::apiResource('api/settings', 'Api\SettingsController');

Route::get('api/function/get-all-providers', 'Api\ProvidersController@getAll');
Route::get('api/function/get-all-parts', 'Api\PartsController@getAll');
Route::get('api/function/get-all-workers', 'Api\WorkersController@getAll');
Route::get('api/function/get-all-workers-tax', 'Api\WorkersController@getAllWithTax');
Route::put('api/function/worker/sign', 'Api\WorkersController@sign');
Route::put('api/function/worker/manager', 'Api\WorkersController@sign');
Route::get('api/function/get-last-payment/{id}', 'Api\RentController@lastPayment');
Route::get('api/function/get-cant-s/{date}', 'Api\RentController@cantS');
Route::get('api/function/get-all-invoices/{id}', 'Api\RentController@getInvoices');
Route::get('api/function/get-total-invoice/{id}', 'Api\InvoicesController@getTotal');
Route::post('api/function/send-invoice', 'Api\InvoicesController@send');
Route::post('api/function/convert-to-invoice', 'Api\EstimatesController@convertToInvoice');
Route::get('api/function/get-years-payment', 'Api\RentController@yearsPayment');
Route::get('api/function/get-months-payment', 'Api\RentController@monthsPayment');
Route::get('api/function/get-last-month-pay', 'Api\RentController@lastMonthPay');
Route::get('api/function/generate-pdf/{id}', 'AppController@generatePdf');
Route::get('api/function/generate-pdf-estimate/{id}', 'AppController@generatePdfEstimate');
Route::put('api/function/sign-pdf2', 'AppController@singPdf');
Route::post('api/function/pay-rent', 'Api\RentController@payRent');
Route::get('api/function/get-all-clients', 'Api\ClientsController@getAll');
Route::get('api/function/get-available-parts', 'Api\PartsController@getAvailableParts');
Route::get('api/function/get-provider-bills-not-use', 'Api\ProviderBillsController@getProviderBillsNotUse');
Route::post('api/function/change-password', 'Api\UserController@changePassword');

Route::get('api/reports/balance', 'Api\ReportsController@getBalance');
Route::get('api/reports/balance-by-methods', 'Api\ReportsController@getBalanceByMethods');
Route::get('api/reports/balance-by-methods-and-total', 'Api\ReportsController@getBalanceByMethodsAndTotal');
Route::get('api/reports/workers-salary', 'Api\ReportsController@getWorkersSalary');
Route::get('api/reports/parts-expenses', 'Api\ReportsController@getPartsExpenses');
Route::get('api/reports/incomes', 'Api\ReportsController@getIncomes');
Route::get('api/stadistics/get-months', 'Api\StadisticsController@getMonths');
Route::get('api/stadistics/get-current-month', 'Api\StadisticsController@getCurrentMonth');

Route::get('/upload/images', ['as' => 'upload', 'uses' => 'ImageController@getUpload']);
Route::get('/upload/images/all/', 'ImageController@all');
Route::post('/upload/images/upload','ImageController@postUpload');
Route::post('/upload/images/delete', ['as' => 'upload-remove', 'uses' =>'ImageController@deleteUpload']);


//functions

Route::get('functions/set-pay-date', 'FunctionsController@setPayDate');
Route::get('functions/set-total', 'FunctionsController@setTotal');

});
