@extends('layouts.login')

@section('content')
    <!-- begin:: Page -->
    <div class="m-grid m-grid--hor m-grid--root m-page">
            <div class="m-grid__item m-grid__item--fluid m-grid m-grid--hor m-login m-login--signin m-login--2 m-login-2--skin-1" id="m_login" style="background-image: url({{ asset('assets/app/media/img//bg/bg-1.jpg') }});">
                    <div class="m-grid__item m-grid__item--fluid m-login__wrapper">
                            <div class="m-login__container">
                                    <div class="m-login__logo">
                                            <a href="#">
                                                    <img src="{{ asset('assets/app/media/img//logos/logo-1.png') }}">
                                            </a>
                                    </div>
                                    <div class="m-login__signin">
                                        <div class="m-login__head">
                                                <h3 class="m-login__title">Sign In To {{ config('app.name', 'Laravel') }}</h3>
                                        </div>
                                        <form class="m-login__form m-form" method="POST" action="{{ route('login') }}">
                                            {{ csrf_field() }}
                                            <div class="form-group m-form__group {{ $errors->has('email') ? ' has-error' : '' }}">
                                                <input id="email" class="form-control m-input" type="email" placeholder="Email" name="email" autocomplete="off" value="{{ old('email') }}" required autofocus/>
                                                    @if ($errors->has('email'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('email') }}</strong>
                                                        </span>
                                                    @endif
                                            </div>
                                            <div class="form-group m-form__group {{ $errors->has('password') ? ' has-error' : '' }}">
                                                    <input id="password" type="password" class="form-control m-input m-login__form-input--last" placeholder="Password" name="password" required>
                                                    @if ($errors->has('password'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('password') }}</strong>
                                                        </span>
                                                    @endif
                                            </div>
                                            <div class="row m-login__form-sub">
                                                    <div class="col m--align-left m-login__form-left">
                                                            <label class="m-checkbox  m-checkbox--light">
                                                                    <input type="checkbox" name="remember" {{ old('remember') ? 'checked' : '' }}> Remember Me
                                                                    <span></span>
                                                            </label>
                                                    </div>
                                                    <div class="col m--align-right m-login__form-right">
                                                        <a class="m-link" id="m_login_forget_password" href="{{ route('password.request') }}">
                                                            Forget Password ?
                                                        </a>
                                                    </div>
                                            </div>
                                            <div class="m-login__form-action">
                                                    <button id="m_login_signin_submit" class="btn btn-focus m-btn m-btn--pill m-btn--custom m-btn--air  m-login__btn m-login__btn--primary" type="submit">Sign In</button>
                                            </div>
                                        </form>
                                    </div>
                            </div>
                    </div>
            </div>
    </div>
    <!-- end:: Page -->
@endsection
