<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBillPartsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bill_parts', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('bill_id')->unsigned()->nullable();
            $table->integer('part_id')->unsigned()->nullable();
            $table->integer('quantity')->unsigned()->nullable();
            $table->string('part_number')->nullable();
            $table->string('name')->nullable();
            $table->text('description')->nullable();
            $table->double("price")->nullable();
            $table->double("extend")->nullable();
            $table->enum('warranty', ['-','1 year','2 year','3 year','4 year','5 year','6 year','lifetime'])->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bill_parts');
    }
}
