<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('invoice_number')->unsigned()->nullable();
            $table->integer('bill_id_old')->unsigned()->nullable();
            $table->timestamp('form_date')->nullable();
            $table->string('client_ab')->nullable();
            $table->enum('written_estimate', ['y', 'n', 'exceed'])->nullable();
            $table->double("written_amount")->default(0);
            $table->double("cancel_fee")->default(0);
            $table->double("storage_fee")->default(0);
            $table->enum('diagnostic_type', ['hourly_at', 'per_hour'])->default("per_hour")->nullable();
            $table->double("diagnostic_amount")->default(0);
            $table->enum('charges_type', ['flat', 'hourly', 'both'])->nullable();
            $table->double('charges_amount')->default(0);
            $table->double('sublet_other')->default(0);
            $table->double('shop_supplies')->default(0);
            $table->double('fees')->default(0);
            $table->enum('save_old_parts', ['yes', 'no'])->nullable();
            $table->text('complaint_problem')->nullable();
            $table->enum('warranty_type', ['month', 'mile'])->nullable();
            $table->string('warranty_amount')->nullable();
            $table->double('miles_in')->default(0);
            $table->double('miles_out')->default(0);
            $table->enum('payment_method', ['cash', 'check', 'debit', 'credit'])->nullable();
            $table->enum('repair_type', ['estimate', 'invoice'])->nullable();
            $table->integer('client_id')->unsigned()->nullable();
            $table->integer('vehicle_id')->unsigned()->nullable();
            $table->integer('worker_id')->unsigned()->nullable();
            $table->integer('prov')->unsigned()->nullable();
            $table->string('part_invoice')->nullable();
            $table->string('pdf_date')->nullable();
            $table->string('pdf_time')->nullable();
            $table->text('pdf')->nullable();
            $table->text('pdf_signed')->nullable();
            $table->string('status')->default('paid');
            $table->double('total')->unsigned()->default(0);
            $table->boolean('deleted')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoices');
    }
}
