<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Client;

class ClientsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $per_page = 25;
        if(!empty($request->get("per_page"))) $per_page =  $request->get("per_page");
        $data = Client::where("clients.deleted", 0)
                ->when($request->get("name"), function($query) use ($request){
                        return $query->where("name", "like", "%".$request->get("name")."%");
                    })
                ->when($request->get("email"), function($query) use ($request){
                        return $query->where("email", "like", "%".$request->get("email")."%");
                    })
                ->when($request->get("phone"), function($query) use ($request){
                        return $query->where("phone", "like", "%".$request->get("phone")."%");
                    })
                ->orderBy('id','DESC')
                ->paginate($per_page);
        return $data;
    }
   public function getAll(Request $request)
{
    $query = Client::where("deleted", 0); // Condición base
    
    if ($request->has('search') && !empty($request->input('search'))) {
        $searchTerm = '%' . $request->input('search') . '%';
        $query->where(function($q) use ($searchTerm) {
            $q->where('name', 'LIKE', $searchTerm)
              ->orWhere('phone', 'LIKE', $searchTerm);
        });
    }
    
    return $query->get();
}

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            "name" => 'required',
            "state" => 'required',
            //"email" => 'email',
        ]);
        Client::create($request->all());
        return;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data = Client::findOrFail($id);
        return $data;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            "name" => 'required',
            "state" => 'required',
            //"email" => 'email',
        ]);
        Client::find($id)->update($request->all());
        return;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Client::findOrFail($id);
        $data->deleted = 1;
        $data->save();
        //$data->delete();
    }
}
